/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.connect;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.pmod.ModelEnabledBean;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTreeModel;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ConnectTask
extends PresentationTask
implements PmDataBean,
ModelActionListener,
ModelEnabledBean {
    private static final String TRACE_MASKT = "XUCNTSKT";
    private static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.servlet.connect.res.connect";
    String userName;
    Locale clientLocale;
    SessionsModel sessionsModel;
    PanelModel offerPanelModel;
    private boolean taskCompleted;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public ConnectTask(PresentationTaskParms parms) {
        super(parms);
    }

    protected Object runTask() throws Exception {
        PanelModelTaskPortal portal = this.getPanelModelTaskPortal();
        portal.setRefreshEnabled(false);
        portal.setEmbedded(true);
        HMCSession hmcSession = this.getHMCSession();
        this.userName = hmcSession.getUserContext().getUserName();
        this.clientLocale = hmcSession.getUserContext().getLocale();
        Collection disconnectedSessions = HMCSession.getDisconnectedSessions(this.userName);
        Trace.trace(TRACE_MASKT, "Running ConnectTask for user \"" + this.userName + "\", offering " + disconnectedSessions.size() + " disconnected sessions.");
        if (disconnectedSessions.isEmpty()) {
            Trace.trace(TRACE_MASKT, "ConnectTask ending.  No disconnected sessions available.");
            return null;
        }
        this.offerSessionList(disconnectedSessions);
        return null;
    }

    protected void offerSessionList(Collection disconnectedSessions) {
        this.sessionsModel = new SessionsModel(disconnectedSessions);
        this.offerPanelModel = new PanelModel("com.ibm.hwmca.fw.servlet.connect.res.sessionList", RESOURCE_BUNDLE, this, this.getHMCSession().getUserContext().getLocales());
        this.offerPanelModel.addModelActionListener(this);
        this.offerPanelModel.render();
        this.waitForTaskToFinish();
    }

    private synchronized void waitForTaskToFinish() {
        Trace.trace(TRACE_MASKT, "ConnectTask waiting for user to select a response.");
        while (!this.taskCompleted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCompletionInfo(String parms) {
        String redirectURL = ServletRuntime.getRuntime().getHMCContextPath() + "/connect?" + parms;
        Trace.trace(TRACE_MASKT, "Setting redirect URL to: " + redirectURL);
        this.getPanelModelTaskPortal().setRedirectURL(redirectURL);
        this.offerPanelModel.dispose();
        ConnectTask connectTask = this;
        synchronized (connectTask) {
            this.taskCompleted = true;
            this.notify();
        }
    }

    protected HMCSession getSelectedSession() {
        HMCSession hmcSession = this.sessionsModel.getSelectedSession();
        try {
            if (hmcSession == null) {
                LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "mustChooseRowTitle");
                MessageText message = new MessageText(RESOURCE_BUNDLE, "mustChooseRowMessage");
                CommonMsgApp.showMessageBox(null, title, message, MsgType.WARNING_MESSAGE, buttons);
                return null;
            }
            if (!hmcSession.isDisconnected()) {
                LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "isConnectedTitle");
                MessageText message = new MessageText(RESOURCE_BUNDLE, "isConnectedMessage");
                CommonMsgApp.showMessageBox(null, title, message, MsgType.WARNING_MESSAGE, buttons);
                this.sessionsModel.deleteSelectedSession();
                if (this.sessionsModel.getRowCount() == 0) {
                    this.setCompletionInfo("");
                }
                return null;
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Ignoring exception rendering \"must choose row\" message.");
            Trace.trace(TRACE_MASKT, e);
        }
        return hmcSession;
    }

    protected void processReconnect() {
        this.offerPanelModel.commitPanelChanges();
        HMCSession hmcSession = this.getSelectedSession();
        if (hmcSession == null) {
            return;
        }
        this.setCompletionInfo("session=" + hmcSession.getSessionId());
    }

    protected void processNewSession() {
        this.setCompletionInfo("session=new");
    }

    protected void processDelete() {
        this.offerPanelModel.commitPanelChanges();
        HMCSession hmcSession = this.getSelectedSession();
        if (hmcSession == null) {
            return;
        }
        Trace.trace(TRACE_MASKT, "Deleting HMC Session \"" + hmcSession.getSessionId() + '\"');
        hmcSession.destroy();
        this.sessionsModel.deleteSelectedSession();
        if (this.sessionsModel.getRowCount() == 0) {
            this.setCompletionInfo("");
        }
    }

    protected void processCancel() {
        Trace.trace(TRACE_MASKT, "Canceling session choosing and HMC connection");
        this.setCompletionInfo("session=cancel");
    }

    public void actionPerformed(ModelActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("reconnect")) {
            this.processReconnect();
        } else if (command.equals("newsession")) {
            this.processNewSession();
        } else if (command.equals("delete")) {
            this.processDelete();
        } else if (command.equals("cancel")) {
            this.processCancel();
        }
    }

    public void logException(Throwable throwable) {
    }

    protected void forceTermination(String reason) {
        this.setCompletionInfo("session=cancel");
    }

    public String getUserName() {
        return this.userName;
    }

    public PmListModel getListModel(String modelName) {
        return null;
    }

    public PmTableModel getTableModel(String modelName) {
        if (modelName.equals("sessions")) {
            return this.sessionsModel;
        }
        return null;
    }

    public PmTreeModel getTreeModel(String modelName) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SessionsModel
    implements PmTableModel {
        List disconnectedSessions;
        int selectedRowIndex;
        String idHeader;
        String disconnectTimeHeader;
        String creationTimeHeader;
        String runningTaskHeader;
        DateFormat dateformatter;

        SessionsModel(Collection disconnectedSessions) {
            this.disconnectedSessions = new ArrayList(disconnectedSessions);
            Collections.sort(this.disconnectedSessions, new Comparator(this){
                private final /* synthetic */ SessionsModel this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    return -((HMCSession)o1).getDisconnectionTime().compareTo(((HMCSession)o2).getDisconnectionTime());
                }
            });
            ResourceBundle bundle = ResourceBundle.getBundle(ConnectTask.RESOURCE_BUNDLE, ConnectTask.this.clientLocale);
            this.idHeader = bundle.getString("idHeader");
            this.disconnectTimeHeader = bundle.getString("disconnectTimeHeader");
            this.creationTimeHeader = bundle.getString("creationTimeHeader");
            this.runningTaskHeader = bundle.getString("runningTaskHeader");
            this.dateformatter = DateFormat.getDateTimeInstance(2, 2, ConnectTask.this.clientLocale);
            this.dateformatter.setTimeZone(ConnectTask.this.getHMCSession().getUserContext().getTimeZone());
            this.selectedRowIndex = 0;
        }

        public HMCSession getSelectedSession() {
            if (this.selectedRowIndex == -1) {
                return null;
            }
            return (HMCSession)this.disconnectedSessions.get(this.selectedRowIndex);
        }

        public void deleteSelectedSession() {
            if (this.selectedRowIndex == -1) {
                return;
            }
            this.disconnectedSessions.remove(this.selectedRowIndex);
            this.selectedRowIndex = -1;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getRowCount() {
            return this.disconnectedSessions.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.idHeader;
                }
                case 1: {
                    return this.disconnectTimeHeader;
                }
                case 2: {
                    return this.creationTimeHeader;
                }
                case 3: {
                    return this.runningTaskHeader;
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectTask.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ConnectTask.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            HMCSession session = (HMCSession)this.disconnectedSessions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return session.getDisplayableSessionId();
                }
                case 1: {
                    return this.dateformatter.format(session.getDisconnectionTime());
                }
                case 2: {
                    return this.dateformatter.format(session.getCreationTime());
                }
                case 3: {
                    return new Integer(session.getRunningTasks().size());
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        public void setSelected(int[] selected) {
            this.selectedRowIndex = selected.length == 0 ? -1 : selected[0];
        }

        public int[] getSelected() {
            if (this.selectedRowIndex == -1) {
                return new int[0];
            }
            return new int[]{this.selectedRowIndex};
        }
    }
}

